/*
  Temprature and Humidity Data Logger V1.3
 
 Writes temprature, humidity, time and date to SD Memory card. Only updates when 'now.minute()' is 
 00 or 30 to provide more accurate results
 
 Uno - Compatiable 
 
 The circuit:
 * LEDs on pins 2 through to 6 to ground
 * Real Time Clock (DS1307) on SDA and SCL
 * SD memory Card on pins 10 - 13 
 * DHT 22 on pin 2, PWR and GND
 
 Software Librarys:
 Freetronics DHT22 - https://github.com/freetronics/DHT-sensor-library
 RTC Library - https://github.com/adafruit/RTClib
 
 
 --20,632 Bytes--
 
 created 13 July 2013
 by Jed Hodson
 
 */

//Include 
#include <SD.h>
#include <Wire.h>
#include "RTClib.h"
#include "DHT.h"
//Setup CS on SD Card (53 for mega, 10 for UNO)
const int chipSelect = 10;
//Setup RTC
RTC_DS1307 RTC;
//Setup DHT
#define DHTPIN 2     // what pin we're connected to
#define DHTTYPE DHT22   // DHT 22  (AM2302)
DHT dht(DHTPIN, DHTTYPE);

//Setup LED pins
int sdError = 3;
int dhtError = 4;
int writingLED = 5;
int rtcError = 6;
int sdStatus = 7;

void setup()
{
  //Setup LEDs
  pinMode(sdError,OUTPUT);
  pinMode(dhtError,OUTPUT);
  pinMode(writingLED,OUTPUT);
  pinMode(rtcError, OUTPUT);
  pinMode(sdStatus, OUTPUT);
  digitalWrite(sdError, LOW);
  digitalWrite(dhtError, LOW);
  digitalWrite(writingLED, LOW);
  digitalWrite(rtcError, LOW);
  digitalWrite(sdStatus, OUTPUT);

  //Initializing SD
  digitalWrite(sdStatus, HIGH);
  delay(950);
  digitalWrite(sdStatus, LOW);
  delay(950);
  digitalWrite(sdStatus, HIGH);
  delay(950);
  digitalWrite(sdStatus, LOW);
  delay(950);
  digitalWrite(sdStatus, HIGH);
  delay(950);
  digitalWrite(sdStatus, LOW);
  delay(950);
  digitalWrite(sdStatus, HIGH);
  delay(950);
  digitalWrite(sdStatus, LOW);
  delay(950);
  digitalWrite(sdStatus, HIGH);
  delay(950);
  digitalWrite(sdStatus, LOW);

  pinMode(10, OUTPUT);
  // see if the card is present and can be initialized:
  if (!SD.begin(chipSelect)) {
    digitalWrite(sdError, HIGH);
    // don't do anything more:
    return;
  }
  digitalWrite(sdStatus, HIGH);
  //Setup DS1307
  Wire.begin();
  RTC.begin();
  if (! RTC.isrunning()) {
    digitalWrite(rtcError, HIGH);
    delay(950);
    digitalWrite(rtcError, LOW);
    // following line sets the RTC to the date & time this sketch was compiled
    RTC.adjust(DateTime(__DATE__, __TIME__));
  }
  //Setup DHT
  dht.begin();
}

void loop()
{
  DateTime now = RTC.now();
  if(now.minute() == 00 || now .minute() == 30)
  {
    String dataString = "";
    DateTime now = RTC.now();
    float h = dht.readHumidity();
    float t = dht.readTemperature();
    // check if returns are valid, if they are NaN (not a number) then something went wrong!
    if (isnan(t) || isnan(h)) {
      digitalWrite(dhtError, HIGH);
      delay(950);
      digitalWrite(dhtError, LOW);
    }
    //Create String to print to SD Card
    int humid = h;
    dataString += "Humidity";
    dataString += ", ";
    dataString += String(humid);
    dataString += "%";
    int temp = t;
    dataString += ", Temprature";
    dataString += String(temp);
    dataString += "*C";
    dataString += " at";
    dataString += " ";
    dataString += String(now.year());
    dataString += "/";
    dataString += String(now.month());
    dataString += "/";
    dataString += String(now.day());
    dataString += ", ";
    dataString += String(now.hour());
    dataString += ":";
    dataString += String(now.minute());
    dataString += ":";
    dataString += String(now.second());
    // open the file. note that only one file can be open at a time,
    // so you have to close this one before opening another.
    File dataFile = SD.open("datalog.txt", FILE_WRITE);

    // if the file is available, write to it:
    if (dataFile) {
      dataFile.println(dataString);
      dataFile.close();
      // flash writing led too
      digitalWrite(writingLED, HIGH);
      delay(950);
      digitalWrite(writingLED, LOW);
    }  
    // if the file isn't open, pop up an error:
    else {
      digitalWrite(sdError, HIGH);
      delay(950);
      digitalWrite(sdError, LOW);
    }
    //delay for 59 seconds to prevent updates happening in minute
    delay(59000);
  }
}








